<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WithdrawalCategory;
use Illuminate\Support\Facades\Auth;
use App\Models\WithdrawalSubCategory;
use App\Models\WithdrawalHistory;


class CashoutController extends Controller
{
    public function index()
    {
        $activeTemplate = getActiveTemplate();
        $userBalance = Auth::user()->balance;

        $withdrawals = WithdrawalCategory::with('subCategories')->get();

        $amounts = $withdrawals->flatMap->subCategories->pluck('amount')->sort();

        $withdrawalAmount = $amounts->first(fn($amount) => $amount >= $userBalance) ?? 0;

        $progressPercentage = $withdrawalAmount > 0
            ? min(($userBalance / $withdrawalAmount) * 100, 100)
            : 0;


        return view($activeTemplate . '.cashout', compact('withdrawals', 'userBalance', 'withdrawalAmount', 'progressPercentage'));
    }

    public function store(Request $request)
    {

        $validated = $request->validate([
            'item_id' => 'required|exists:withdrawal_sub_categories,id',
            'wallet' => 'required|string',
            'withdrawal_categories_id' => 'required|exists:withdrawal_categories,id',
        ]);

        $user = auth()->user();
        $item = WithdrawalSubCategory::findOrFail($validated['item_id']);

        // Check if user has sufficient balance
        if ($user->balance < $item->amount) {
            return redirect()->back()->with('error', 'Insufficient funds! Please ensure you have enough balance to complete this transaction.');
        }


        if (is_null($user->email_verified_at)) {
            return redirect()->back()->with('error', 'Your email is not verified! Please verify your email to proceed.');
        }

        $user->decrement('balance', $item->amount);

        WithdrawalHistory::create([
            'user_id' => $user->id,
            'amount' => $item->amount,
            'withdrawal_categories_id' => $validated['withdrawal_categories_id'],
            'redeem_wallet' => str_replace(' ', '', $validated['wallet']),
        ]);

        return redirect()->route('profile.show')->with('success', 'Withdrawal request submitted successfully!');
    }

}
