<?php

namespace App\Http\Controllers\Postback;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Network;
use App\Models\User;
use App\Models\Track;
use App\Models\ReferralLog;

class CallbackController extends Controller
{
    public function index(Request $request, $param_secret, $network_slug)
    {
        $network = Network::where('param_secret', $param_secret)
            ->where('network_slug', $network_slug)
            ->where('network_status', 1)
            ->first();

        if (!$network) {
            return response('Invalid secret or network slug.', 404);
        }

        $validMethods = ['GET', 'POST'];
        if (!in_array($network->postback_method, $validMethods) || !$request->isMethod($network->postback_method)) {
            return response('Invalid request method.', 405);
        }

        if (strtoupper($request->method()) !== strtoupper($network->postback_method)) {
            return response('Parameters should be sent via ' . strtoupper($network->postback_method), 403);
        }

        $reward = floatval($request->input('reward') ?: $request->input('value'));
        $payout = floatval($request->input('payout'));

        $offerName = $request->input('of_name')
            ?: $request->input('offer_name')
            ?: 'N/A';

        $offerId = intval($request->input('of_id', 0));

        $uid = $request->input('uid') ?: $request->input('user_id') ?: $request->input('subId');

        $ip = $request->input('ip') ?: $request->input('userIp') ?: '0.0.0.0';

        $country = $request->input('country');
        $transactionId = $request->input('tx_id') ?: $request->input('token') ?: $request->input('transId');

        $status = $this->determineStatus($request->input('status'), $payout, $reward);


        if (
            Track::where([
                ['partners', $network_slug],
                ['transaction_id', $transactionId],
                ['uid', $uid],
                ['status', $status]
            ])->exists()
        ) {
            return response('Transaction ID already exists for this user', 400);
        }

        $user = User::where('uid', $uid)->first() ?? abort(404, 'User not found.');

        $reward = $network->param_custom_rate !== null ? $payout * $network->param_custom_rate : $reward;
        $reward = floatval($reward);


        $perc = ReferralCommission();

        $bonusAmount = $reward * ($perc / 100);

        if ($user->invited_by && $perc > 0 && $perc <= 100) {
            $invitedByUser = User::find($user->invited_by);
            $invitedByUser->increment('balance', $bonusAmount);
            ReferralLog::create([
                'referrer_id' => $user->invited_by,
                'user_id' => $user->id,
                'earnings' => $bonusAmount,
                'offer_id' => $offerId,
            ]);
        }

        $status == 1 ? $user->increment('balance', $reward) : ($status == 2 ? $user->decrement('balance', $reward) : null);

        $country = $country ?? ($ip != '0.0.0.0' ? getCountryCode($ip) : null);

        Track::create([
            'offer_id' => $offerId,
            'offer_name' => $offerName,
            'transaction_id' => $transactionId,
            'reward' => $reward,
            'payout' => $payout,
            'ip' => $ip,
            'country' => $country,
            'status' => $status,
            'uid' => $uid,
            'partners' => $network->network_name,
        ]);

        return response('OK', 200);
    }

    private function determineStatus($status, $payout, $reward)
    {

        if (is_null($status)) {
            if ($payout > 0 || $reward > 0) {
                return 1;
            } elseif ($payout < 0 || $reward < 0) {
                return 2;
            } else {
                return null;
            }
        } else {
            if (in_array($status, [1, 'approved', 'completed', 'credited', 'COMPLETE'])) {
                return 1;
            } elseif (in_array($status, [2, 0, 'rejected', 'RECONCILIATION'])) {
                return 2;
            } else {
                return null;
            }
        }
    }


}
