<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use App\Models\TermsOfServiceManagements;
use App\Models\Track;
use App\Models\WithdrawalHistory;
use Carbon\Carbon;


class SiteController extends Controller
{
    public function referralCode(Request $request, $referral_code)
    {
        Cookie::queue('referral_code', $referral_code, 1440); // Cookie expires in 1 day (1440 minutes)
        return redirect()->route('home');
    }


    public function privacy()
    {
        $privacy = TermsOfServiceManagements::select('privacy_policy', 'privacy_policy_updated_at')->first();
        $this->formatUpdatedDate($privacy, 'privacy_policy_updated_at');

        $activeTemplate = getActiveTemplate();
        return view($activeTemplate . '.tos.privacy', compact('privacy'));
    }

    public function terms()
    {
        $terms = TermsOfServiceManagements::select('terms_of_use', 'terms_of_use_updated_at')->first();
        $this->formatUpdatedDate($terms, 'terms_of_use_updated_at');

        $activeTemplate = getActiveTemplate();
        return view($activeTemplate . '.tos.terms', compact('terms'));
    }

    private function formatUpdatedDate($model, $dateField)
    {
        if ($model->$dateField) {
            $model->formatted_updated_at = Carbon::parse($model->$dateField)->format('F j, Y');
        } else {
            $model->formatted_updated_at = null;
        }
    }
    
    public function getSiteStatists()
    {
        $offers = Track::with('user:id,uid,name,avatar,gender')
            ->orderBy('updated_at', 'desc')
            ->take(10)
            ->get();
    
        $withdrawals = WithdrawalHistory::with(['user:id,name,avatar', 'category:id,name,cover'])
            ->orderBy('updated_at', 'desc')
            ->take(10)
            ->get();
    
        $combinedData = [];
    
    
        foreach ($offers as $offer) {
            
            if($offer && $offer->user){
                
                $combinedData[] = [
                    'type'       => 'offer',
                    'username'   => $offer->user->name,
                    'gender'     => $offer->user->gender,
                    'image'      => $offer->user->avatar, 
                    'title'      => $offer->partners,
                    'reward'     => $offer->reward,
                    'updated_at' => $offer->updated_at,
                ];
            }
        }
        
    
        foreach ($withdrawals as $withdrawal) {
            
            if($withdrawal && $withdrawal->user && $withdrawal->category){
                
                $combinedData[] = [
                    'type'         => 'withdrawal',
                    'username'     => $withdrawal->user->name,
                    'user_image'   => $withdrawal->user->avatar,
                    'method'       => $withdrawal->category->name, 
                    'method_image' => $withdrawal->category->cover, 
                    'amount'       => $withdrawal->amount,
                    'updated_at'   => $withdrawal->updated_at,
                ];
            }
        }
    
        usort($combinedData, function ($a, $b) {
            return strtotime($b['updated_at']) - strtotime($a['updated_at']);
        });
    
        return view(  getActiveTemplate() . '.partials.site-status', compact('combinedData'))->render();
    }
}
