<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;



return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
        then: function () {
            Route::middleware('web')
                ->group(base_path('routes/auth.php'));
            Route::prefix('backend')->middleware('web')->namespace('Admin')
                ->name('admin.')
                ->group(base_path('routes/admin.php'));
        },
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->validateCsrfTokens(except: [
            'callback/*',
        ]);
        $middleware->redirectTo(
            guests: '/',
            users: '/earn',
        );

        $middleware->alias([
            'guest:admin' => \App\Http\Middleware\Admin::class,
            'active' => \App\Http\Middleware\CheckUserStatus::class,
            'auto_ban_country_change' => \App\Http\Middleware\AutoBanOnCountryChange::class,
            'auto_vpn_ban' => \App\Http\Middleware\AutoBanVPN::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
