@extends('admin.layouts.master')

@section('title', 'System Settings')

@section('content')
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">

                <div class="col-12">
                    <x-admin.alert />
                </div>
                <!-- Cron Job Section -->
                <div class="col-12">
                    <div class="card mb-3">
                        <div class="card-header">
                            <h4 class="card-title">Cron Job Commands</h4>
                        </div>
                        <div class="card-body">
                            <pre class="bg-dark p-2" style="white-space: pre-wrap;">
    <span class="text-success"># Cron Job Command</span><br>
    &nbsp;{{ str_replace('lsphp', 'php', PHP_BINARY) }} {{ base_path('artisan') }} schedule:run >> /dev/null 2>&1<br><br>
</pre>



                            <small class="text-muted">Copy the above commands and add them to your server's crontab.</small>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <form action="{{ route('admin.settings.update') }}" method="POST" class="card"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="card-header">
                            <h4 class="card-title">{{ SiteName() }} Settings</h4>
                        </div>
                        <div class="card-body">
                            <div class="row g-5">
                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-4">
                                            <div class="mb-3">
                                                <label class="form-label">Site Name:</label>
                                                <input type="text" class="form-control" name="site_name"
                                                    value="{{ old('site_name', $systemSettings['site_name']) }}">
                                                @error('site_name')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="mb-3">
                                                <label class="form-label">Referral Percentage:</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="referral_percentage"
                                                        value="{{ old('referral_percentage', $systemSettings['referral_percentage']) }}">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                @error('referral_percentage')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="mb-3">
                                                <label class="form-label">Site Symbol:</label>
                                                <input type="text" class="form-control" name="site_currency_symbol"
                                                    value="{{ old('site_currency_symbol', $systemSettings['site_currency_symbol']) }}">
                                                @error('site_currency_symbol')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-4">
                                            <div class="mb-3">
                                                <label class="form-label">Proxycheck Api key</label>
                                                <input type="text" class="form-control" name="proxycheck_api_key"
                                                    value="{{ old('proxycheck_api_key', $systemSettings['proxycheck_api_key']) }}">
                                                @error('proxycheck_api_key')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                                <small>
                                                    <a href="https://www.proxycheck.io/get-api" target="_blank"
                                                        rel="noopener noreferrer" class="text-red">Click here to get your
                                                        API</a>
                                                </small>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="hr-text my-4 text-cyan">Design Settings</div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <div class="form-label">Select Theme</div>
                                                <select class="form-select" name="active_template">
                                                    @foreach ($templates as $key => $templateName)
                                                        <option value="{{ $templateName }}"
                                                            {{ old('active_template', $systemSettings['active_template'] ?? '') == $templateName ? 'selected' : '' }}>
                                                            {{ $templateName }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('active_template')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">Site Logo:</label>
                                                <input type="file" class="form-control" name="site_logo">
                                                @error('site_logo')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">Favicon:</label>
                                                <input type="file" class="form-control" name="site_favicon">
                                                @error('site_favicon')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="hr-text my-4 text-cyan">SEO Settings</div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">SEO Description:</label>
                                                <textarea class="form-control" name="seo_description" rows="1">{{ old('seo_description', $systemSettings['seo_description']) }}</textarea>
                                                @error('seo_description')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">SEO Keywords:</label>
                                                <input type="text" class="form-control" name="seo_keywords"
                                                    value="{{ old('seo_keywords', $systemSettings['seo_keywords']) }}">
                                                @error('seo_keywords')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label">Google Analytics Tracking ID:</label>
                                                <input type="text" class="form-control" name="google_analytics_key"
                                                    value="{{ old('google_analytics_key', $systemSettings['google_analytics_key']) }}">
                                                @error('google_analytics_key')
                                                    <small class="text-red">{{ $message }}</small>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <button type="submit" class="btn btn-dark">Save Settings</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
