<button class="api-offers-card swiper-slide mb-2" data-bs-toggle="modal" data-bs-target="#ApiModal"
    data-name="<?php echo e($name); ?>" data-creative="<?php echo e($creative); ?>" data-payout="<?php echo e(number_format($payout, 2)); ?>"
    data-device="<?php echo e($device); ?>" data-requirements="<?php echo e($requirements); ?>" data-link="<?php echo e($link); ?>"
    data-description="<?php echo e($description); ?>" data-event='<?php echo json_encode($event, 15, 512) ?>'>
    <div class="row align-items-center">
        <div class="col-auto">
            <img src="<?php echo e($creative); ?>" alt="<?php echo e($name); ?>" class="img-fluid" />
        </div>
        <div class="col">
            <p class="mb-0 fw-semibold">
                <?php echo e(strlen($name) > 10 ? substr($name, 0, 10) . '...' : $name); ?></p>
            <small class="d-flex justify-content-start align-items-center mb-2 fs-13">Game</small>
            <div class="d-flex justify-content-between align-items-center">
                <?php
                    $formattedPayout = number_format($payout, 2);
                    [$integerPart, $decimalPart] = explode('.', $formattedPayout);
                ?>
                <div class="cpi fs-13"><?php echo e(siteSymbol() . $integerPart); ?>.<span><?php echo e($decimalPart); ?></span></div>
                <div class="system d-flex align-items-center justify-content-center ms-3">
                    <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/icons/' . ($device ?: 'desktop') . '.svg')); ?>"
                        alt="<?php echo e($device ?: 'desktop'); ?>" />
                </div>
            </div>
        </div>
    </div>
</button>
<?php /**PATH /home/u987726886/domains/lootdollar.com/public_html/core/resources/views/templates/garnet/partials/slide.blade.php ENDPATH**/ ?>