
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', 'Earn'); ?>

<?php $__env->startSection('content'); ?>

    <!--Device Detection-->
    <section class="device-detection">
        <div class="d-flex align-items-center px-3">
            <h1 class="mb-0 me-0">You are now</h1>
            <span class="mx-4">On</span>
            <div class="device">
                <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/icons/' . $device . '.svg')); ?>"
                    class="img-fluid me-2" alt="<?php echo e($device); ?>" />
                <?php echo e(ucfirst($device)); ?>


            </div>
        </div>
    </section>
    <?php if(isset($isVPNDetected) && $isVPNDetected): ?>
        <!--VPN Detected -->
        <section class="vpn-detect d-flex align-items-center justify-content-center px-4 py-5">
            <div class="text-center">
                <h2 class="mb-0">
                    <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/shield.png')); ?>" class="img-fluid"
                        alt="shield" />
                </h2>
                <div class="vpn mt-3">
                    <h2>VPN Detected</h2>
                    <p>Please turn off your VPN for a smoother browsing experience. Thank you for your understanding!</p>
                </div>

            </div>
        </section>
    <?php else: ?>
        <?php if(isOgadsApiEnabled() || isAdgateApiEnabled() || isNotikApiEnabled()): ?>
            <!--API Offers-->
            <section class="cover api-offers mb-3">
                <div class="sec-title pt-4 pb-2 px-4 d-flex align-items-center justify-content-between">
                    <h2 class="mb-0">
                        <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/icons/rocket.svg')); ?>" class="img-fluid"
                            alt="rocket" />
                        Latest Offers
                    </h2>
                    <div class="slid-button d-flex gap-2">
                        <div id="prev-api-offers" class="prev">&lt;</div>
                        <div id="next-api-offers" class="next">&gt;</div>
                    </div>
                </div>
                <?php if(count($adgateOffers) > 0): ?>
                    <div class="row api-offers-row flex-nowrap overflow-hidden pt-3 mx-0 swiper-container"
                        id="api-offers-1">
                        <div class="swiper-wrapper px-0">
                            <?php $__currentLoopData = $adgateOffers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adgate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make($activeTemplate . '.partials.slide', [
                                    'name' => $adgate->name,
                                    'creative' => $adgate->creative,
                                    'payout' => $adgate->payout,
                                    'device' => $adgate->device ?: 'desktop',
                                    'requirements' => $adgate->requirements,
                                    'link' => Auth::check() ? $adgate->link . Auth::user()->uid : '#',
                                    'description' => $adgate->description,
                                    'event' => $adgate->event,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    </div>
                <?php endif; ?>
                <?php if(count($notikOffers) > 0): ?>
                    <div class="row api-offers-row flex-nowrap overflow-hidden pt-3 mx-0 swiper-container"
                        id="api-offers-2">
                        <div class="swiper-wrapper px-0">
                            <?php $__currentLoopData = $notikOffers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notik): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make($activeTemplate . '.partials.slide', [
                                    'name' => $notik->name,
                                    'creative' => $notik->creative,
                                    'payout' => $notik->payout,
                                    'device' => $notik->device ?: 'desktop',
                                    'requirements' => $notik->requirements,
                                    'link' => Auth::check() ? str_replace('[user_id]', Auth::user()->uid, $notik->link) : '#',
                                    'description' => $notik->description,
                                    'event' => $notik->event,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    </div>
                <?php endif; ?>
                <?php if(count($ogadsOffers) > 0): ?>
                    <div class="row api-offers-row flex-nowrap overflow-hidden pt-3 mx-0 swiper-container"
                        id="api-offers-3">
                        <div class="swiper-wrapper px-0">
                            <?php $__currentLoopData = $ogadsOffers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ogads): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make($activeTemplate . '.partials.slide', [
                                    'name' => $ogads['name_short'],
                                    'creative' => $ogads['picture'],
                                    'payout' => $ogads['payout'],
                                    'device' => $device,
                                    'requirements' => $ogads['adcopy'],
                                    'link' => Auth::check() ? $ogads['link'] . Auth::user()->uid : '#',
                                    'description' => $ogads['description'],
                                    'event' => null,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    </div>
                <?php endif; ?>


            </section>
        <?php endif; ?>
        <!--Offerwalls-->
        <section class="offerwalls px-4 position-relative overflow-hidden">
            <h1 class="site-name text-uppercase"><?php echo e(SiteName()); ?></h1>
            <?php if(count($offer_networks) > 0): ?>
                <div class="offerwall mb-3">
                    <div class="sec-title pt-4 pb-0 d-flex align-items-center justify-content-between">
                        <h2 class="mb-0">
                            <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/icons/joystick.svg')); ?>"
                                class="img-fluid" alt="joystick" />
                            Offer Partners
                        </h2>
                        <div class="slid-button d-flex gap-2">
                            <div id="prev-offerwalls" class="prev">&lt;</div>
                            <div id="next-offerwalls" class="next">&gt;</div>
                        </div>
                    </div>

                    <div class="row flex-nowrap overflow-x-hidden pt-5 swiper-container" id="offerwalls">
                        <div class="swiper-wrapper px-0">
                            <?php $__currentLoopData = $offer_networks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-auto partners-card swiper-slide">
                                    <a href="javascript:void(0);" class="text-white" data-bs-toggle="modal"
                                        data-bs-target="<?php echo e(Auth::check() ? '#WallModal' : '#authModal'); ?>"
                                        onclick="<?php echo e(Auth::check() ? '' : 'selectCreateAccountTab()'); ?>"
                                        data-url="<?php echo e($offer->offerwall_url); ?>">
                                        <svg width="170" height="210" viewBox="0 0 170 210" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0.5 15.5711C0.5 14.3776 0.974106 13.233 1.81802 12.3891L12.3891 1.81802C13.233 0.974108 14.3776 0.5 15.5711 0.5H164.5C166.983 0.5 169 2.53051 169 5.01815V5.44639V5.874V6.30098V6.72733V7.15307V7.57819V8.00269V8.42657V8.84984V9.27251V9.69457V10.116V10.5369V10.9571V11.3768V11.7958V12.2143V12.6322V13.0494V13.4661V13.8822V14.2978V14.7127V15.1271V15.5409V15.9541V16.3668V16.7789V17.1904V17.6014V18.0118V18.4216V18.8309V19.2396V19.6478V20.0554V20.4625V20.869V21.275V21.6805V22.0854V22.4898V22.8937V23.297V23.6998V24.102V24.5038V24.905V25.3057V25.7059V26.1056V26.5047V26.9034V27.3015V27.6992V28.0963V28.4929V28.8891V29.2847V29.6799V30.0745V30.4687V30.8624V31.2556V31.6483V32.0405V32.4323V32.8236V33.2144V33.6047V33.9946V34.384V34.7729V35.1614V35.5495V35.937V36.3241V36.7108V37.097V37.4828V37.8681V38.253V38.6375V39.0215V39.405V39.7882V40.1709V40.5532V40.935V41.3164V41.6974V42.078V42.4582V42.838V43.2173V43.5962V43.9748V44.3529V44.7306V45.1079V45.4849V45.8614V46.2375V46.6133V46.9886V47.3636V47.7382V48.1124V48.4862V48.8597V49.2327V49.6054V49.9778V50.3497V50.7213V51.0925V51.4634V51.8339V52.2041V52.5739V52.9433V53.3125V53.6812V54.0496V54.4177V54.7854V55.1528V55.5199V55.8866V56.253V56.6191V56.9848V57.3502V57.7153V58.0801V58.4445V58.8087V59.1725V59.536V59.8993V60.2622V60.6248V60.9871V61.3491V61.7108V62.0722V62.4334V62.7942V63.1548V63.515V63.875V64.2347V64.5942V64.9533V65.3122V65.6708V66.0292V66.3873V66.7451V67.1026V67.4599V67.817V68.1738V68.5303V68.8866V69.2426V69.5984V69.954V70.3093V70.6644V71.0192V71.3738V71.7282V72.0824V72.4363V72.79V73.1435V73.4967V73.8498V74.2026V74.5552V74.9076V75.2598V75.6118V75.9636V76.3152V76.6666V77.0178V77.3688V77.7197V78.0703V78.4207V78.771V79.1211V79.471V79.8207V80.1702V80.5196V80.8688V81.2178V81.5667V81.9154V82.2639V82.6123V82.9606V83.3086V83.6566V84.0043V84.352V84.6995V85.0468V85.394V85.7411V86.088V86.4348V86.7815V87.128V87.4744V87.8207V88.1669V88.5129V88.8588V89.2047V89.5504V89.896V90.2415V90.5868V90.9321V91.2773V91.6224V91.9674V92.3123V92.6571V93.0018V93.3464V93.691V94.0354V94.3798V94.7241V95.0683V95.4125V95.7566V96.1006V96.4446V96.7885V97.1323V97.4761V97.8198V98.1634V98.5071V98.8506V99.1941V99.5376V99.881V100.224V100.568V100.911V101.254V101.598V101.941V102.284V102.627V102.97V103.314V103.657V104V104.343V104.686V105.029V105.372V105.715V106.058V106.401V106.744V107.087V107.431V107.774V108.117V108.46V108.803V109.146V109.489V109.833V110.176V110.519V110.862V111.206V111.549V111.893V112.236V112.58V112.923V113.267V113.61V113.954V114.298V114.642V114.985V115.329V115.673V116.017V116.362V116.706V117.05V117.394V117.739V118.083V118.428V118.773V119.118V119.462V119.807V120.152V120.498V120.843V121.188V121.534V121.879V122.225V122.571V122.917V123.263V123.609V123.955V124.301V124.648V124.994V125.341V125.688V126.035V126.382V126.73V127.077V127.425V127.772V128.12V128.468V128.817V129.165V129.513V129.862V130.211V130.56V130.909V131.258V131.608V131.957V132.307V132.657V133.008V133.358V133.709V134.059V134.41V134.761V135.113V135.464V135.816V136.168V136.52V136.872V137.225V137.578V137.931V138.284V138.637V138.991V139.345V139.699V140.053V140.408V140.763V141.118V141.473V141.828V142.184V142.54V142.896V143.253V143.61V143.967V144.324V144.681V145.039V145.397V145.755V146.114V146.473V146.832V147.191V147.551V147.911V148.271V148.631V148.992V149.353V149.714V150.076V150.438V150.8V151.163V151.526V151.889V152.252V152.616V152.98V153.344V153.709V154.074V154.439V154.805V155.171V155.537V155.904V156.271V156.638V157.006V157.374V157.742V158.111V158.48V158.849V159.219V159.589V159.959V160.33V160.701V161.073V161.445V161.817V162.189V162.562V162.936V163.31V163.684V164.058V164.433V164.808V165.184V165.56V165.936V166.313V166.69V167.068V167.446V167.824V168.203V168.582V168.962V169.342V169.723V170.104V170.485V170.867V171.249V171.631V172.014V172.398V172.782V173.166V173.551V173.936V174.322V174.708V175.094V175.481V175.869V176.257V176.645V177.034V177.423V177.813V178.203V178.594V178.985V179.377V179.769V180.161V180.554V180.948V181.342V181.736V182.131V182.527V182.923V183.319V183.716V184.114V184.512V184.91V185.31V185.709V186.109V186.51V186.911V187.312V187.714V188.117V188.52V188.924V189.328V189.733V190.138V190.544V190.951V191.358V191.765V192.173V192.582V192.991V193.4V193.811C169 195.06 168.481 196.267 167.57 197.117L155.6 208.29C154.766 209.067 153.669 209.5 152.529 209.5H5C2.51472 209.5 0.5 207.485 0.5 205V15.5711Z"
                                                fill="#1C171D" stroke="#E9213D" />
                                        </svg>
                                        <div class="partners-content text-center">
                                            <div class="bonus ms-auto"><?php echo e($offer->network_description); ?></div>
                                            <div class="partners-body px-3">
                                                <img src="<?php echo e(url($offer->network_image)); ?>" class="img-fluid"
                                                    alt="<?php echo e($offer->network_name); ?>" />
                                            </div>
                                            <div class="partners-footer">
                                                <p class="fs-13"><?php echo e($offer->network_name); ?></p>
                                                <div class="stars">
                                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                                        <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/icons/active-stars.svg')); ?>"
                                                            class="<?php echo e($i > $offer->network_rating ? 'opacity-50' : ''); ?>"
                                                            alt="Star" />
                                                    <?php endfor; ?>
                                                </div>

                                            </div>
                                        </div>
                                    </a>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>


                    </div>
                </div>
            <?php endif; ?>
            <?php if(count($survey_networks) > 0): ?>
                <div class="surveys mb-3">
                    <div class="sec-title pt-4 pb-0 d-flex align-items-center justify-content-between">
                        <h2 class="mb-0">
                            <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/icons/joystick.svg')); ?>"
                                class="img-fluid" alt="joystick" />
                            Survey Partners
                        </h2>
                        <div class="slid-button d-flex gap-2">
                            <div id="prev-surveys" class="prev">&lt;</div>
                            <div id="next-surveys" class="next">&gt;</div>
                        </div>
                    </div>
                    <div class="row flex-nowrap overflow-x-hidden pt-5 swiper-container" id="surveys">
                        <div class="swiper-wrapper px-0">
                            <?php $__currentLoopData = $survey_networks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-auto partners-card swiper-slide mb-3">
                                    <a href="javascript:void(0);" class="text-white" data-bs-toggle="modal"
                                        data-bs-target="<?php echo e(Auth::check() ? '#WallModal' : '#authModal'); ?>"
                                        onclick="<?php echo e(Auth::check() ? '' : 'selectCreateAccountTab()'); ?>"
                                        data-url="<?php echo e($survey->offerwall_url); ?>">
                                        <svg width="170" height="210" viewBox="0 0 170 210" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0.5 15.5711C0.5 14.3776 0.974106 13.233 1.81802 12.3891L12.3891 1.81802C13.233 0.974108 14.3776 0.5 15.5711 0.5H164.5C166.983 0.5 169 2.53051 169 5.01815V5.44639V5.874V6.30098V6.72733V7.15307V7.57819V8.00269V8.42657V8.84984V9.27251V9.69457V10.116V10.5369V10.9571V11.3768V11.7958V12.2143V12.6322V13.0494V13.4661V13.8822V14.2978V14.7127V15.1271V15.5409V15.9541V16.3668V16.7789V17.1904V17.6014V18.0118V18.4216V18.8309V19.2396V19.6478V20.0554V20.4625V20.869V21.275V21.6805V22.0854V22.4898V22.8937V23.297V23.6998V24.102V24.5038V24.905V25.3057V25.7059V26.1056V26.5047V26.9034V27.3015V27.6992V28.0963V28.4929V28.8891V29.2847V29.6799V30.0745V30.4687V30.8624V31.2556V31.6483V32.0405V32.4323V32.8236V33.2144V33.6047V33.9946V34.384V34.7729V35.1614V35.5495V35.937V36.3241V36.7108V37.097V37.4828V37.8681V38.253V38.6375V39.0215V39.405V39.7882V40.1709V40.5532V40.935V41.3164V41.6974V42.078V42.4582V42.838V43.2173V43.5962V43.9748V44.3529V44.7306V45.1079V45.4849V45.8614V46.2375V46.6133V46.9886V47.3636V47.7382V48.1124V48.4862V48.8597V49.2327V49.6054V49.9778V50.3497V50.7213V51.0925V51.4634V51.8339V52.2041V52.5739V52.9433V53.3125V53.6812V54.0496V54.4177V54.7854V55.1528V55.5199V55.8866V56.253V56.6191V56.9848V57.3502V57.7153V58.0801V58.4445V58.8087V59.1725V59.536V59.8993V60.2622V60.6248V60.9871V61.3491V61.7108V62.0722V62.4334V62.7942V63.1548V63.515V63.875V64.2347V64.5942V64.9533V65.3122V65.6708V66.0292V66.3873V66.7451V67.1026V67.4599V67.817V68.1738V68.5303V68.8866V69.2426V69.5984V69.954V70.3093V70.6644V71.0192V71.3738V71.7282V72.0824V72.4363V72.79V73.1435V73.4967V73.8498V74.2026V74.5552V74.9076V75.2598V75.6118V75.9636V76.3152V76.6666V77.0178V77.3688V77.7197V78.0703V78.4207V78.771V79.1211V79.471V79.8207V80.1702V80.5196V80.8688V81.2178V81.5667V81.9154V82.2639V82.6123V82.9606V83.3086V83.6566V84.0043V84.352V84.6995V85.0468V85.394V85.7411V86.088V86.4348V86.7815V87.128V87.4744V87.8207V88.1669V88.5129V88.8588V89.2047V89.5504V89.896V90.2415V90.5868V90.9321V91.2773V91.6224V91.9674V92.3123V92.6571V93.0018V93.3464V93.691V94.0354V94.3798V94.7241V95.0683V95.4125V95.7566V96.1006V96.4446V96.7885V97.1323V97.4761V97.8198V98.1634V98.5071V98.8506V99.1941V99.5376V99.881V100.224V100.568V100.911V101.254V101.598V101.941V102.284V102.627V102.97V103.314V103.657V104V104.343V104.686V105.029V105.372V105.715V106.058V106.401V106.744V107.087V107.431V107.774V108.117V108.46V108.803V109.146V109.489V109.833V110.176V110.519V110.862V111.206V111.549V111.893V112.236V112.58V112.923V113.267V113.61V113.954V114.298V114.642V114.985V115.329V115.673V116.017V116.362V116.706V117.05V117.394V117.739V118.083V118.428V118.773V119.118V119.462V119.807V120.152V120.498V120.843V121.188V121.534V121.879V122.225V122.571V122.917V123.263V123.609V123.955V124.301V124.648V124.994V125.341V125.688V126.035V126.382V126.73V127.077V127.425V127.772V128.12V128.468V128.817V129.165V129.513V129.862V130.211V130.56V130.909V131.258V131.608V131.957V132.307V132.657V133.008V133.358V133.709V134.059V134.41V134.761V135.113V135.464V135.816V136.168V136.52V136.872V137.225V137.578V137.931V138.284V138.637V138.991V139.345V139.699V140.053V140.408V140.763V141.118V141.473V141.828V142.184V142.54V142.896V143.253V143.61V143.967V144.324V144.681V145.039V145.397V145.755V146.114V146.473V146.832V147.191V147.551V147.911V148.271V148.631V148.992V149.353V149.714V150.076V150.438V150.8V151.163V151.526V151.889V152.252V152.616V152.98V153.344V153.709V154.074V154.439V154.805V155.171V155.537V155.904V156.271V156.638V157.006V157.374V157.742V158.111V158.48V158.849V159.219V159.589V159.959V160.33V160.701V161.073V161.445V161.817V162.189V162.562V162.936V163.31V163.684V164.058V164.433V164.808V165.184V165.56V165.936V166.313V166.69V167.068V167.446V167.824V168.203V168.582V168.962V169.342V169.723V170.104V170.485V170.867V171.249V171.631V172.014V172.398V172.782V173.166V173.551V173.936V174.322V174.708V175.094V175.481V175.869V176.257V176.645V177.034V177.423V177.813V178.203V178.594V178.985V179.377V179.769V180.161V180.554V180.948V181.342V181.736V182.131V182.527V182.923V183.319V183.716V184.114V184.512V184.91V185.31V185.709V186.109V186.51V186.911V187.312V187.714V188.117V188.52V188.924V189.328V189.733V190.138V190.544V190.951V191.358V191.765V192.173V192.582V192.991V193.4V193.811C169 195.06 168.481 196.267 167.57 197.117L155.6 208.29C154.766 209.067 153.669 209.5 152.529 209.5H5C2.51472 209.5 0.5 207.485 0.5 205V15.5711Z"
                                                fill="#1C171D" stroke="#E9213D" />
                                        </svg>
                                        <div class="partners-content text-center">
                                            <div class="bonus ms-auto"><?php echo e($survey->network_description); ?></div>
                                            <div class="partners-body px-3">
                                                <img src="<?php echo e(url($survey->network_image)); ?>" class="img-fluid"
                                                    alt="<?php echo e($survey->network_name); ?>" />
                                            </div>
                                            <div class="partners-footer">
                                                <p class="fs-13"><?php echo e($survey->network_name); ?></p>
                                                <div class="stars">
                                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                                        <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/icons/active-stars.svg')); ?>"
                                                            class="<?php echo e($i > $survey->network_rating ? 'opacity-50' : ''); ?>"
                                                            alt="Star" />
                                                    <?php endfor; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    </div>
                </div>
            <?php endif; ?>
        </section>
        <?php echo $__env->make($activeTemplate . '.partials.modals.offerwall', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make($activeTemplate . '.partials.modals.api', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", () => {
            const initSwiper = (container, nextEl, prevEl, paginationEl) => new Swiper(container, {
                slidesPerView: 'auto',
                loop: false,
                freeMode: true,
                pagination: {
                    el: paginationEl,
                    clickable: true,
                },
                navigation: {
                    nextEl,
                    prevEl,
                },
            });

            const offerwallsSwiper = initSwiper('#offerwalls', '#next-offerwalls', '#prev-offerwalls',
                '.swiper-pagination');
            const surveysSwiper = initSwiper('#surveys', '#next-surveys', '#prev-surveys', '.swiper-pagination');
            const apiOffers1Swiper = initSwiper('#api-offers-1', '#next-api-offers', '#prev-api-offers',
                '#api-offers-1 .swiper-pagination');
            const apiOffers2Swiper = initSwiper('#api-offers-2', '#next-api-offers', '#prev-api-offers',
                '#api-offers-2 .swiper-pagination');
            const apiOffers3Swiper = initSwiper('#api-offers-3', '#next-api-offers', '#prev-api-offers',
                '#api-offers-3 .swiper-pagination');

            const syncNavigations = (buttonId, action) => {
                const button = document.getElementById(buttonId);
                if (button) {
                    button.addEventListener('click', () => {
                        if (action === 'prev') {
                            apiOffers1Swiper.slidePrev();
                            apiOffers2Swiper.slidePrev();
                        } else {
                            apiOffers1Swiper.slideNext();
                            apiOffers2Swiper.slideNext();
                        }
                    });
                }
            };

            syncNavigations('prev-api-offers', 'prev');
            syncNavigations('next-api-offers', 'next');
        });
    </script>
    <?php if(auth()->guard()->check()): ?>
        <script>
            document.addEventListener("DOMContentLoaded", () => {
                const modal = new bootstrap.Modal(document.getElementById("WallModal"));
                const iframe = document.getElementById("offerwallIframe");
                const preloader = document.getElementById("offerwall-preloader");

                document.querySelectorAll('[data-bs-toggle="modal"]').forEach(element => {
                    element.addEventListener("click", function() {
                        const offerUrl = this.getAttribute("data-url");

                        if (!offerUrl || !modal || !iframe || !preloader) return;

                        iframe.src = offerUrl;
                        preloader.style.display = "flex";
                        modal.show();

                        iframe.onload = () => {
                            preloader.style.display = "none";
                        };
                    });
                });
            });
        </script>
    <?php endif; ?>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const modal = document.getElementById('ApiModal');

            modal.addEventListener('show.bs.modal', event => {
                const button = event.relatedTarget;
                const siteSymbol = <?php echo json_encode(siteSymbol(), 15, 512) ?>;
                const assetBaseUrl = "<?php echo e(asset('assets/' . $activeTemplate . '/images/icons')); ?>";

                const name = button.getAttribute('data-name');
                const creative = button.getAttribute('data-creative');
                const payout = button.getAttribute('data-payout');
                const device = button.getAttribute('data-device');
                const requirements = button.getAttribute('data-requirements');
                const description = button.getAttribute('data-description');
                const link = button.getAttribute('data-link');
                const eventData = button.getAttribute('data-event');

                modal.querySelector('#modal-game-name').textContent = name;
                modal.querySelector('#game-payout').textContent = `$${payout}`;
                modal.querySelector('#game-requirement').textContent = requirements;
                modal.querySelector('#game-description').textContent = description;
                modal.querySelector('#data-creative').setAttribute('src', creative);
                modal.querySelector('#game-device').setAttribute('src', `${assetBaseUrl}/${device}.svg`);
                modal.querySelector('#link-payout').textContent = `Earn ${siteSymbol}${payout}`;

                const gameLink = modal.querySelector('#game-link');
                gameLink.setAttribute('href', link);

                if (link === '#') {
                    gameLink.setAttribute('data-bs-toggle', 'modal');
                    gameLink.setAttribute('data-bs-target', '#authModal');
                    gameLink.setAttribute('onclick', 'selectCreateAccountTab()');
                } else {
                    gameLink.setAttribute('target', '_blank');
                    gameLink.removeAttribute('data-bs-toggle');
                    gameLink.removeAttribute('data-bs-target');
                    gameLink.removeAttribute('onclick');
                }


                const modalEvents = modal.querySelector('#modal-events');
                modalEvents.innerHTML = '';

                if (eventData) {
                    try {
                        const jsonData = JSON.parse(eventData.trim());
                        if (Array.isArray(jsonData)) {
                            jsonData.forEach((task, index) => {
                                const taskDiv = document.createElement('div');
                                taskDiv.className =
                                    'd-flex align-items-center gap-4 task border-bottom';

                                const badgeSpan = document.createElement('span');
                                badgeSpan.className = 'badge';
                                badgeSpan.textContent = index + 1;

                                const taskDescriptionSpan = document.createElement('span');
                                taskDescriptionSpan.className = 'text-white fs-13';
                                taskDescriptionSpan.textContent = task.name;

                                const priceSpan = document.createElement('span');
                                priceSpan.className = 'text-warning ms-auto fw-semibold';
                                priceSpan.textContent = `$${task.payout.toFixed(2)}`;

                                taskDiv.append(badgeSpan, taskDescriptionSpan, priceSpan);
                                modalEvents.appendChild(taskDiv);
                            });
                        }
                    } catch (e) {}
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . '.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u987726886/domains/lootdollar.com/public_html/core/resources/views/templates/garnet/home.blade.php ENDPATH**/ ?>